************************************
*** This do-file creates Table 6 ***
************************************

clear
clear matrix
set mem 300m

* !!! PLEASE SPECIFY !!! the directory where the file nj_respondents_new.dta is stored:
local njdir=""

* load file
use `njdir'nj_respondents_new.dta, clear

* sample restriction: age 20-65, not working in survey week, did not accept job in survey week or earlier
drop if insample_wrkacc==0
drop if age > 65
drop if age < 20

* generate day of the week dummies (for time use diary)
tab q2, gen(q2_)
drop q2_1


* "curwkwgt_tu" is the time use diary weight (which assigns weekdays and weekends the correct shares).
* We do not use these weights here, but drop observations when the weights are missing.
* The weights are missing for low quality diaries (more than 2 episodes missing in diary, less than 4 different activities in diary)
replace tu_jobsearch=. if curwkwgt_tu==.
replace tp_jobsearch=. if curwkwgt_tu==.



*** pie chart ***
label variable q10a_1 "Contacted employer directly"
label variable q10a_2 "Public employment agency"
label variable q10a_3 "Private employment agency"
label variable q10a_4 "Friends or relatives"
*label variable q10a_5 "School/University empl. center"
*label variable q10a_6 "Union/professional registers"
label variable q10a_7 "Job training program"
label variable q10a_8 "Placed or answered ads"
label variable q10a_9 "Went to interview"
label variable q10a_10 "Sent out resumes/applications"
label variable q10a_11 "Looked at ads"
label variable q10a_12 "Other"

replace q10a_12 = q10a_12 + q10a_5 + q10a_6

graph pie q10a_1-q10a_4 q10a_8-q10a_12 [aw=curwkwgt], ///
title("All interviews") graphregion(color(white)) ///
pl(1 per, format(%2.0f)) pl(2 per, format(%2.0f)) pl(3 per, format(%2.0f)) pl(4 per, format(%2.0f)) ///
pl(5 per, format(%2.0f)) pl(6 per, format(%2.0f)) pl(7 per, format(%2.0f)) pl(8 per, format(%2.0f)) ///
pl(9 per, format(%2.0f)) pl(10 per, format(%2.0f)) pl(11 per, format(%2.0f)) ///
saving(piechart_fullsample.gph, replace)
graph export `njdir'piechart_fullsample.png, replace hei(1200) wid(1650) 

graph pie q10a_1-q10a_4 q10a_8-q10a_12 [aw=perswgt] if week==1, ///
title("First interview") graphregion(color(white)) ///
pl(1 per, format(%2.0f)) pl(2 per, format(%2.0f)) pl(3 per, format(%2.0f)) pl(4 per, format(%2.0f)) ///
pl(5 per, format(%2.0f)) pl(6 per, format(%2.0f)) pl(7 per, format(%2.0f)) pl(8 per, format(%2.0f)) ///
pl(9 per, format(%2.0f)) pl(10 per, format(%2.0f)) pl(11 per, format(%2.0f)) ///
saving(piechart_1interview.gph, replace)
graph export `njdir'piechart_1interview.png, replace hei(1200) wid(1650) 


grc1leg piechart_1interview.gph piechart_fullsample.gph, legendfrom(piechart_1interview.gph) graphregion(color(white))
graph export `njdir'piechart.png, replace hei(1200) wid(1650) 
graph export `njdir'piechart.eps, replace

